<?php

namespace Tobuli\Importers\Geofence\Readers;

use Tobuli\Importers\Readers\GexpReader;

class GeofenceGexpReader extends GexpReader
{
    protected function parsePoint($data)
    {
        if ( ! empty($data['coordinates'])) {
            $data['polygon'] = json_decode($data['coordinates'], true);
        }

        if ( ! empty($data['group_id'])) {
            $data['group'] = $this->groups[$data['group_id']] ?? null;
            unset($data['group_id']);
        }

        return $data;
    }
}
