<?php

namespace Tobuli\History;


class GroupContainer
{
    /**
     * @var Group[]
     */
    protected $groups = [];

    protected $actives = [];

    protected $reference;

    public function add(Group $group)
    {
        $this->groups[] = $group;
    }

    /**
     * @param Group $group
     * @return Group
     */
    public function open(Group $group)
    {
        $this->add($group);

        $this->lastToActives();

        return $this->last();
    }

    public function close($key, $position)
    {
        if (empty($this->actives))
            return;

        foreach ($this->actives as $i => $index)
        {
            if ($this->groups[$index]->getKey() != $key)
                continue;

            $this->groups[$index]->setEndPosition($position);

            //unset($this->actives[$i]);
        }

        //$this->resetReference();
    }

    public function disactiveClosed()
    {
        if (empty($this->actives))
            return;

        foreach ($this->actives as $i => $index)
        {
            if ($this->groups[$index]->isClose())
                unset($this->actives[$i]);
        }
    }

    /**
     * @return Group[]
     */
    public function actives()
    {
        if (empty($this->actives))
            return [];

        return array_filter($this->groups, function($k) {
            return in_array($k, $this->actives);
        }, ARRAY_FILTER_USE_KEY);
    }

    /**
     * @return Group[]
     */
    public function all()
    {
        return $this->groups;
    }

    /**
     * @return Group
     */
    public function & last()
    {
        return $this->groups[key($this->groups)];
    }

    /**
     * @return boolean
     */
    public function hasActives()
    {
        return ! empty($this->actives);
    }

    /**
     * @param null $key
     * @return Group
     */
    public function merge($key = null)
    {
        $merged = new Group('merge');

        foreach ($this->groups as $group)
        {
            if ( ! is_null($key) && $group->getKey() != $key)
                continue;

            $merged->applyArray($group->stats()->all());
        }

        return $merged;
    }

    public function applyStat($key, $value)
    {
        /*
        if (isset($this->reference))
        {
            $this->reference->applyStat($key, $value);

            return;
        }
        */

        foreach ($this->actives as $index)
        {
            $this->groups[$index]->applyStat($key, $value);
        }
    }

    protected function lastToActives()
    {
        end($this->groups);
        $this->actives[] = key($this->groups);

        //$this->resetReference();
    }

    protected function resetReference()
    {
        unset($this->reference);

        if (count($this->actives) == 1) {
            $index = last($this->actives);
            $this->reference = & $this->groups[$index];
        }
    }

    public function __destruct()
    {
        $this->groups = null;
        $this->actives = null;
        unset($this->reference);
    }
}