<?php

namespace Tobuli\History\Actions;


use Tobuli\History\Stats\Duration AS DurationStat;
use Tobuli\History\Stats\StatCount;

class Overspeed extends ActionStat
{
    static public function required()
    {
        return [
            AppendDuration::class,
            AppendDistance::class,
            AppendOverspeed::class
        ];
    }

    public function boot()
    {
        $this->registerStat('overspeed_duration', new DurationStat());
        $this->registerStat('overspeed_distance', new \Tobuli\History\Stats\Distance());
        $this->registerStat('overspeed_count', new StatCount());
        $this->registerStat('overspeed_positions', new StatCount());
    }

    public function proccess($position)
    {
        if ( ! $this->isOverspeed($position))
            return;

        $this->history->applyStat("overspeed_positions", 1);
        $this->history->applyStat("overspeed_duration", $position->duration);
        $this->history->applyStat("overspeed_distance", $position->distance);

        if ($this->isStart($position))
            $this->history->applyStat("overspeed_count", 1);
    }

    protected function isStart($position)
    {
        return $position->overspeeding == 1;
    }

    protected function isOverspeed($position)
    {
        return isset($position->overspeeding) && $position->overspeeding;
    }
}