<?php

namespace Tobuli\History\Actions;


use Tobuli\History\Group;

class GroupGeofenceOut extends ActionGroup
{
    static public function required()
    {
        return [
            AppendGeofences::class
        ];
    }

    public function boot() {}

    public function proccess($position)
    {
        $enters = $this->enterGeofences($position);

        foreach ($enters as $geofence_id)
        {
            $this->history->groupEnd("geofence_out", $position);
        }

        if (! empty($enters)) {
            return;
        }

        $lefts = $this->leftGeofences($position);

        foreach ($lefts as $geofence_id)
        {
            $group = new Group("geofence_out");
            $group->geofence_id = $geofence_id;

            $this->history->groupStart($group, $position);
        }
    }
}