<?php

namespace Tobuli\History\Actions;


use Tobuli\History\Group;

class GroupDailySplit extends ActionGroup
{
    protected $current;

    static public function required()
    {
        return [
            AppendPosition::class,
            AppendDateUserZone::class,
        ];
    }

    public function boot() {}

    public function proccess($position)
    {
        if (is_null($this->current))
            $this->current = $position->date;

        if ($this->current == $position->date)
            return;

        $groups = $this->history->getGroups()->actives();

        foreach ($groups as $group)
        {
            $this->history->groupEnd($group->getKey(), $position);

            $regroup = new Group($group->getKey());
            $regroup->setMetaContainer( $group->getMetaContainer() );

            $this->history->groupStart($regroup, $position);
        }

        $this->current = $position->date;
    }
}