<?php

namespace Tobuli\History\Actions;


class AppendRouteColor extends ActionAppend
{
    protected $actions = [];

    protected $route_color_sensor;

    protected $color_r;
    protected $color_b;
    protected $color_p;

    static public function required()
    {
        return [
            AppendDrivePrivateSensor::class,
            AppendDriveBusinessSensor::class,
        ];
    }

    public function boot()
    {
        if ( settings('plugins.route_color.status') )
        {
            $this->color_r = settings('plugins.route_color.options.value');
            if ($this->route_color_sensor = $this->getSensor('route_color'))
                $this->actions[] = [$this, 'processRouteColorSensor'];
        }

        if ( settings('plugins.business_private_drive.status') )
        {
            $this->color_b = settings('plugins.business_private_drive.options.business_color.value');
            $this->color_p = settings('plugins.business_private_drive.options.private_color.value');
            $this->actions[] = [$this, 'processDriveBusinessSensor'];
            $this->actions[] = [$this, 'processDrivePrivateSensor'];
        }
    }

    public function proccess(&$position)
    {
        $position->color = 'blue';

        foreach ($this->actions as $action)
            call_user_func_array($action, [ & $position]);
    }

    protected function processRouteColorSensor(& $position)
    {
        if ( ! $this->getSensorValue($this->route_color_sensor, $position, false))
            return;

        $position->color = $this->color_r;
    }

    protected function processDriveBusinessSensor(& $position)
    {
        if ( ! $this->getSensorValue($this->drive_business_sensor, $position, false))
            return;

        $position->color = $this->color_b;
    }

    protected function processDrivePrivateSensor(& $position)
    {
        if ( ! $this->getSensorValue($this->drive_private_sensor, $position, false))
            return;

        $position->color = $this->color_p;
    }
}