<?php

namespace Tobuli\Helpers\Templates\Builders;

use Formatter;
use Tobuli\Entities\Event;
use Tobuli\Helpers\Templates\Replacers\DeviceReplacer;

class EventTemplate extends TemplateBuilder
{
    /**
     * @param Event $event
     * @return array
     */
    protected function variables($event)
    {
        $google_preview = "http://maps.google.com/maps?q={$event->latitude},{$event->longitude}&t=m&hl=";

        $deviceReplacer = (new DeviceReplacer())->setUser($this->user)->setPrefix('device');

        return array_merge([
            '[preview]'   => '<a href="'. $google_preview .'">' . trans('front.preview') . '</a>',
            '[event]'     => $event->message,
            '[address]'   => getGeoAddress($event->latitude, $event->longitude),
            '[position]'  => $event->latitude . '&deg;, ' . $event->longitude . '&deg;',
            '[heading]'   => $event->course,
            '[lat]'       => $event->latitude,
            '[lon]'       => $event->longitude,

            '[altitude]'  => Formatter::altitude()->human($event->altitude),
            '[speed]'     => Formatter::speed()->human($event->speed),
            '[time]'      => Formatter::time()->human($event->time),

            '[geofence]'  => $event->geofence ? $event->geofence->name : null,
        ], $deviceReplacer->replacers($event->device));
    }

    /**
     * @return array
     */
    protected function placeholders()
    {
        return array_merge([
            '[event]'    => 'Event title',
            '[geofence]' => 'Geofence name',
            '[address]'  => 'Address',
            '[position]' => 'Position/Point',
            '[lat]'      => 'Latitude',
            '[lon]'      => 'Longitude',
            '[heading]'  => 'Heading/Course',
            '[preview]'  => 'Google map link',
            '[altitude]' => 'Altitude',
            '[speed]'    => 'Speed',
            '[time]'     => 'Time',
        ], (new DeviceReplacer())->setPrefix('device')->placeholders());
    }
}