<?php

namespace Tobuli\Helpers\Payments\Gateways;

use Illuminate\Http\Request;

interface PaymentGatewayInterface
{
    public function pay($user, $plan);

    public function payCallback(Request $request);

    public function subscribe($user, $plan);

    public function subscribeCallback(Request $request);

    public function checkout($plan_id);

    public function isConfigCorrect(Request $request);

    public function isSubscriptionActive($subscription);

    public function cancelSubscription($subscription);
}