<?php

namespace Tobuli\Helpers\Payments\Gateways;

use Validator;
use App\Exceptions\PaymentsConfigurationException;
use App\Exceptions\PaymentsIssueException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;

class FreeGateway extends PaymentGateway implements PaymentGatewayInterface
{
    public function pay($user, $plan)
    {
        if ( ! $plan->isFree())
            throw new PaymentsIssueException('Plan not free');

        do
        {
            $unique = md5(time());

            $validator = Validator::make(
                ['data' => $unique],
                ['data' => 'required|unique:subscriptions,gateway_id']
            );
        } while($validator->fails());

        $this->storeSubscription($user, $plan, $unique);
        $this->activateSubscription($unique);

        return Redirect::route('payments.success');
    }

    public function payCallback(Request $request)
    {
        return Redirect::route('payments.success');
    }

    public function subscribe($user, $plan)
    {
        return Redirect::route('payments.subscribe_callback', [
            'gateway'         => $this->gatewayName(),
            'subscription_id' => null,
        ]);
    }

    public function subscribeCallback(Request $request)
    {
        return Redirect::route('payments.success');
    }

    public function checkout($plan_id)
    {
        return view('front::Subscriptions.Gateways.free')->with([
            'plan_id'    => $plan_id,
            'gateway'    => $this->gatewayName(),
        ]);
    }

    public function isConfigCorrect(Request $request)
    {
        return true;
    }

    public function isSubscriptionActive($subscription)
    {
        return true;
    }

    public function cancelSubscription($subscription)
    {
        return true;
    }
}