<?php

namespace Tobuli\Helpers\Formatter\Unit;

abstract class Numeric extends Unit
{
    protected $ratio = 1;
    protected $precision = 0;

    abstract public function byUnit($unit);

    public function setRatio($ratio)
    {
        $this->ratio = $ratio;

        return $this;
    }

    public function getRatio()
    {
        return $this->ratio;
    }

    public function convert($value)
    {
        return $value * $this->ratio;
    }

    public function reverse($value)
    {
        return $value * (1 / $this->ratio);
    }

    public function format($value)
    {
        $converted = $this->convert($value);

        return round($converted, $this->precision);
    }

    public function human($value)
    {
        return $this->format($value) . ($this->unit() ? ' ' . $this->unit() : '');
    }
}