<?php namespace Tobuli\Helpers\Dashboard\Blocks;

class DeviceStatusCountsBlock extends Block
{
    protected function getName()
    {
        return 'device_status_counts';
    }

    protected function getContent()
    {
        if (is_null($devices = $this->user->devices()->with(['traccar'])->get()))
            return null;

        $device_count = $devices->count();

        $offline = $devices->filter(function ($device) {
            return $device->isOffline();
        });

        $offline_count = $offline->count();

        $never_connected = $devices->filter(function ($device) {
            return $device->isNeverConnected();
        });

        $expired = $devices->filter(function ($device) {
            return $device->isExpired();
        });

        return [
            'devices' => $device_count,
            'online'  => $device_count - $offline_count,
            'offline' => $offline_count,
            'never_connected' => $never_connected->count(),
            'expired' => $expired->count(),
        ];
    }
}