<?php namespace Tobuli\Helpers\Dashboard\Blocks;

use Carbon\Carbon;
use Tobuli\Lookups\Tables\DevicesIdleLookupTable;
use Tobuli\Lookups\Tables\DevicesInactiveLookupTable;
use Tobuli\Lookups\Tables\DevicesMoveLookupTable;
use Tobuli\Lookups\Tables\DevicesNeverConnectedLookupTable;
use Tobuli\Lookups\Tables\DevicesOfflineLookupTable;
use Tobuli\Lookups\Tables\DevicesStopLookupTable;

class DeviceOverviewBlock extends Block
{
    protected function getName()
    {
        return 'device_overview';
    }

    protected function getContent()
    {
        $devices = $this->user->devices()->with(['traccar'])->get();
        $events = $this->user->events()->with(['device', 'geofence'])->latest()->limit(7)->get();

        return [
            'statuses' => $this->getStatuses($devices),
            'events' => $events
        ];
    }

    protected function getStatuses($devices)
    {

        return [
            [
                'label' => trans('front.move'),
                'data' => $devices->filter(function ($device) {
                    return $device->isMove();
                })->count(),
                'color' => '#52BE80',
                'url' => DevicesMoveLookupTable::route('index')
            ],
            [
                'label' => trans('front.idle'),
                'data' => $devices->filter(function ($device) {
                    return $device->isIdle();
                })->count(),
                'color' => '#F7DC6F',
                'url' => DevicesIdleLookupTable::route('index')
            ],
            [
                'label' => trans('front.stop'),
                'data' => $devices->filter(function ($device) {
                    return $device->isStop();
                })->count(),
                'color' => '#EC7063',
                'url' => DevicesStopLookupTable::route('index')
            ],
            [
                'label' => trans('front.offline'),
                'data' => $devices->filter(function ($device) {
                    return $device->isOffline();
                })->count(),
                'color' => '#5DADE2',
                'url'  => DevicesOfflineLookupTable::route('index')
            ],
            [
                'label' => trans('front.inactive'),
                'data' => $devices->filter(function ($device) {
                    return $device->isInactive();
                })->count(),
                'color' => '#D7DBDD',
                'url' => DevicesInactiveLookupTable::route('index')
            ],
            [
                'label' => trans('front.never_connected'),
                'data' => $devices->filter(function ($device) {
                    return $device->isNeverConnected();
                })->count(),
                'color' => '#AF7AC5',
                'url' => DevicesNeverConnectedLookupTable::route('index')
            ]
        ];
    }
}