<?php namespace Tobuli\Helpers\Dashboard\Blocks;

use Carbon\Carbon;
use Tobuli\Entities\Device;

class DeviceDistanceBlock extends Block implements BlockInterface
{
    const DAYS_PERIOD = 5;

    /**
     * @return string
     */
    protected function getName()
    {
        return 'device_distance';
    }

    /**
     * Device ditances devided into day intevals.
     *
     * @return array
     */
    protected function getContent()
    {
        $results = [];
        $keys = [];

        $from = Carbon::now()->startOfDay();
        $to   = Carbon::now();

        $i = 0;
        while ($i < self::DAYS_PERIOD)
        {
            $from_date = $from->toDateString();

            $devices = $this->user->devices()->orderBy('updated_at','desc')->limit(10)->get()->sortBy('timestamp');

            foreach ($devices as $device)
            {
                $first = $device->positions()
                    ->whereBetween('time', [$from_date, $to->toDateTimeString()])
                    ->orderBy('time', 'asc')
                    ->limit(1);

                $positions = $device->positions()
                    ->whereBetween('time', [$from_date, $to->toDateTimeString()])
                    ->orderBy('time', 'desc')
                    ->limit(1)
                    ->union($first)
                    ->get();

                if ($positions->count() != 2) {
                    $results[$device->name][] = [$i, 0];
                    continue;
                }

                $results[$device->name][] = [
                    $i,
                    $this->getDistanceTravelled($device, $positions)
                ];
            }

            $keys[] = date('F j', strtotime($from_date));
            $to = clone $from;
            $from->subDay();
            $i++;
        }

        return [
            'data' => json_encode($results),
            'keys' => json_encode($keys),
        ];
    }

    /**
     * If available return odometer parameter, else GPS calculated distance.
     *
     * @param $device
     * @param $first
     * @param $last
     * @return mixed
     */
    private function getDistanceTravelled($device, $positions)
    {
        $odometer = $device->getOdometerSensor();

        if ( ! is_null($odometer)) {
            $distance = $this->getByOdometer($odometer, $positions);

            if ($distance > 0)
                return $distance;
        }

        $distance = $this->getByVirtual($positions);

        return ($distance > 0) ? $distance : 0;
    }

    private function getByOdometer($odometer, $positions)
    {
        return $odometer->getValue($positions[0]['other'], false) - $odometer->getValue($positions[1]['other'], false);
    }

    private function getByVirtual($positions)
    {
        return $positions[0]->getParameter('totaldistance') - $positions[1]->getParameter('totaldistance');
    }
}