<?php

namespace Tobuli\Exporters\Device;

use Maatwebsite\Excel\Facades\Excel;

class XlsExporter extends Exporter
{
    public function export($devices, $attributes)
    {
        $this->filename = uniqid('', TRUE) . '.xls';

        $this->file = Excel::create($this->filename, function ($excel) use ($devices, $attributes) {

            $excel->sheet('Report', function ($sheet) use ($devices, $attributes) {

                $sheet->appendRow($attributes);

                foreach ($devices as $device) {
                    foreach ($attributes as $attribute) {
                        $values[] = $device->$attribute ? $device->$attribute : ' ';
                    }

                    $sheet->appendRow($values);

                    $values = [];
                }

            });
        });

        return $this;
    }

    public function download()
    {
        return $this->file->export('xls');
    }
}