<?php

namespace Tobuli\Cache;


use Illuminate\Cache\DatabaseStore;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Encryption\Encrypter;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;

class SqliteStore extends DatabaseStore
{

    public function __construct()
    {
        $config = config('cache.stores.sqlite');

        parent::__construct(
            $connection = app('db')->connection('sqlite'),
            $encrypter = new Encrypter(md5('encrypter-salt', true)),
            $config['table'],
            $config['prefix']
        );
    }

    public function flush()
    {
        if (Schema::connection('sqlite')->hasTable('cache')) {
            try {
                DB::connection('sqlite')->table('cache')->delete();
                //optimizes db, including filesize
                DB::connection('sqlite')->statement('VACUUM;');
            } catch (\Exception $e) {
                return false;
            }
        }

        return true;
    }
}