<?php namespace ModalHelpers;

use App\Exceptions\ResourseNotFoundException;
use Facades\Repositories\ReportLogRepo;
use Facades\Repositories\UserRepo;
use Tobuli\Exceptions\ValidationException;

class ReportLogModalHelper extends ModalHelper
{
	private $types = [];
	private $formats = [];
	private $mimes = [];

	function __construct()
	{
		parent::__construct();

		$this->types = [
            '1' => trans('front.general_information'),
            '2' => trans('front.general_information_merged'),
            '16' => trans('front.general_information_merged_custom'),
            '42' => trans('front.general_information_merged_custom_2'),
            '49' => trans('front.general_information_merged_custom_3'),
            '3' => trans('front.drives_and_stops'),
            '18' => trans('front.drives_and_stops').' / '.trans('front.geofences'),
            '19' => trans('front.drives_and_stops').' / '.trans('front.drivers'),
            '21' => trans('front.drives_and_stops').' / '.trans('front.drivers') . ' (Business)',
            '22' => trans('front.drives_and_stops').' / '.trans('front.drivers') . ' (Private)',
            '41' => trans('front.drives_and_stops_simplified'),
            '40' => trans('front.stops'),
            '4' => trans('front.travel_sheet'),
            '39' => trans('front.travel_sheet_custom'),
            '5' => trans('front.overspeeds'),
            '47' => trans('front.overspeeds') . ' / ' . trans('front.geofences'),
            '6' => trans('front.underspeeds'),
            '7' => trans('front.geofence_in_out'),
            '15' => trans('front.geofence_in_out_24_mode'),
            '20' => trans('front.geofence_in_out').' ('.trans('front.ignition_on_off').')',
            '28' => trans('front.geofence_in_out').' (Shift)',
            '31' => trans('front.geofence_touch_all'),
            '44' => trans('front.geofence_touch_all_2'),
            '8' => trans('front.events'),
            /*'9' => trans('front.service'),*/
            '10' => trans('front.fuel_level'),
            '11' => trans('front.fuel_fillings'),
            '12' => trans('front.fuel_thefts'),
            '13' => trans('front.temperature'),
            '14' => trans('front.rag'),
            '23' => trans('front.rag').' / '.trans('front.seatbelt'),
            '24' => 'Birla ' . trans('global.custom'),
            '25' => trans('front.object_history'),
            //'26' => trans('front.object_history'),
            '27' => 'Automon ' . trans('global.custom'),
            '29' => trans('front.engine_hours') . ' ' . trans('validation.attributes.daily'),
            '30' => trans('front.ignition_on_off'),
            '32' => trans('front.sent_commands'),
            '33' => trans('front.overspeed_custom'),
            '34' => trans('front.overspeed_custom_summary'),
            '35' => trans('front.installation_all_objects'),
            '36' => trans('front.installation_offline_objects'),
            '37' => trans('front.loading_unloading'),
            '38' => trans('front.offline_objects'),
            '43' => trans('front.routes'),
            '46' => trans('front.expenses'),
            '45' => trans('front.speed_report'),
            '48' => trans('front.work_hours_daily')
		];

		$this->formats = [
			'html' => trans('front.html'),
			'xls' => trans('front.xls'),
			'pdf' => trans('front.pdf'),
            'pdf_land' => trans('front.pdf_land'),
		];

		$this->mimes = [
			'html' => 'plain/text',
			'xls' => 'application/vnd.ms-excel',
			'pdf' => 'application/pdf',
            'pdf_land' => 'application/pdf',
		];

        $this->exts = [
            'html' => 'html',
            'xls' => 'xls',
            'pdf' => 'pdf',
            'pdf_land' => 'pdf',
        ];
	}

	public function get()
	{
		$filter	= ['user_ids' => [$this->user->id]];

		if ($this->user->isManager()) {
			$filter = ['user_ids' => UserRepo::getWhere(['manager_id' => $this->user->id])->lists('id', 'id')->all()];
			$filter['user_ids'][] = $this->user->id;
		}

		if ($this->user->isAdmin())
		    unset($filter['user_ids']);

		$logs = ReportLogRepo::searchAndPaginate(['filter' => $filter], 'id', 'desc', 10);
		foreach ( $logs as $index => $log )
		{
			$logs[ $index ]->type_text = empty($this->types[ $log->type ]) ? $log->type : $this->types[ $log->type ];
			$logs[ $index ]->format_text = empty($this->formats[ $log->format ]) ? $log->format : $this->formats[ $log->format ];
		}

		return $logs;
	}

	public function download($id)
	{
		$where = isAdmin() ? ['id' => $id] : ['id' => $id, 'user_id' => $this->user->id];

		$log = ReportLogRepo::findWhere($where);

		if ( $log ) {
			$data = $log->data;

			$headers = [
				'Content-Type' => $this->mimes[ $log->format ],
				'Content-Length' => $log->size,
				'Content-Disposition' => 'attachment; filename="' . $log->title . '.' . $this->exts[ $log->format ] . '"'
			];
		}

		return compact('data', 'headers');
	}

	public function destroy()
	{
		if ( empty($this->data['id']) )
		    throw new ResourseNotFoundException('front.report');

		$ids = is_array( $this->data['id'] ) ? $this->data['id'] : [ $this->data['id'] ];

		$items = ReportLogRepo::getWhereIn( $ids );

		if ( empty($items) )
            throw new ResourseNotFoundException('front.report');

		foreach ( $items as $item )
		{
		    if ( ! $this->user->can('remove', $item) )
		        continue;

            $item->delete();
		}

		return ['status' => 1];
	}

}